program dotNetApp;

uses
  System.Windows.Forms,
  System.Runtime.InteropServices,
  System.Security;

type
  TfrmPInvoke = class(Form)
    btnTiming: Button;
    procedure btnTimingClick(Sender: TObject; Args: EventArgs);
  public
    constructor Create;
  end;

{ TfrmPInvoke }

constructor TfrmPInvoke.Create;
begin
  inherited;
  Width := 261;
  Height := 90;
  StartPosition := FormStartPosition.CenterScreen;
  Text := '.NET App Using Win32 Timing Routines';
  FormBorderStyle := FormBorderStyle.FixedSingle;
  MinimizeBox := False;
  MaximizeBox := False;
  btnTiming := Button.Create;
  with btnTiming do
  begin
    Text := 'Accurate Timing';
    SetBounds(16, 16, 225, 33);
    Parent := Self;
    Add_Click(btnTimingClick);
  end;
{.$define PRELINK_INDIVIDUALLY}
{$ifdef PRELINK_INDIVIDUALLY}
  Marshal.Prelink(GetType.Module.GetType('dotNetApp.Unit').GetMethod('QueryPerformanceFrequency'));
  Marshal.Prelink(GetType.Module.GetType('dotNetApp.Unit').GetMethod('QueryPerformanceCounter'));
{$else}
  //Prelink and load all PInvoke routines in this module
  //(an object can tell you its module)
  Marshal.PrelinkAll(GetType.Module.GetType('dotNetApp.Unit'));
{$endif}
end;

//Define one of these three conditional symbols
{.$define LOGICAL_TRANSLATION}
{.$define ACCURATE_TRANSLATION}
{$define EFFICIENT_TRANSLATION} 

const
  kernel32  = 'kernel32.dll';

{$ifdef LOGICAL_TRANSLATION}
function QueryPerformanceCounter(var lpPerformanceCount: Int64): Boolean; stdcall;
external kernel32;

function QueryPerformanceFrequency(var lpFrequency: Int64): Boolean; stdcall;
external kernel32;
{$endif}
{$ifdef ACCURATE_TRANSLATION}
function QueryPerformanceCounter(out lpPerformanceCount: Int64): LongBool; stdcall;
external kernel32;

function QueryPerformanceFrequency(out lpFrequency: Int64): LongBool; stdcall;
external kernel32;
{$endif}
{$ifdef EFFICIENT_TRANSLATION}
[DllImport(kernel32), SuppressUnmanagedCodeSecurity]
function QueryPerformanceCounter(out lpPerformanceCount: Int64): LongBool;
external;

[DllImport(kernel32), SuppressUnmanagedCodeSecurity]
function QueryPerformanceFrequency(out lpFrequency: Int64): LongBool;
external;
{$endif}

procedure TfrmPInvoke.btnTimingClick(Sender: TObject; Args: EventArgs);
var
  StartTime, EndTime, TimerFrequency: Int64;
  TimeDiff, SqrRoot: Double;
  I: Integer;
const
  NumIterations = 100000000;

  procedure TimerError;
  begin
    raise Exception.Create('High accuracy timing not supported on this machine')
  end;

begin
  if not QueryPerformanceFrequency(TimerFrequency) then
    TimerError;
  if not QueryPerformanceCounter(StartTime) then
    TimerError;
  for I := 1 to NumIterations do
    SqrRoot := Sqrt(2);
  if not QueryPerformanceCounter(EndTime) then
    TimerError;
  TimeDiff := (EndTime - StartTime) / TimerFrequency;
  MessageBox.Show(
    Format('%.0n square roots takes %g seconds', [NumIterations * 1.0, TimeDiff]),
    'Timing Results', MessageBoxButtons.OK, MessageBoxIcon.Information)
end;

begin
  Application.Run(TfrmPInvoke.Create);
end.
